<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 27.01.14 11:21
 */

namespace VM\AdminBundle\Services;

use Doctrine\ORM\EntityManager;
use Import\ApiBundle\Entity\PKD;
use Symfony\Component\HttpFoundation\Response;
use VM\ApiBundle\Entity\AccountChange;
use VM\ApiBundle\Entity\Company;
use VM\ApiBundle\Entity\CompanyAllegroCategoryItem;
use VM\ApiBundle\Entity\CompanyBankServiceOption;
use VM\ApiBundle\Entity\CompanyDistributionSales;
use VM\ApiBundle\Entity\CompanyEmployee;
use VM\ApiBundle\Entity\CompanyOffer;
use VM\ApiBundle\Entity\CompanyOfferReport;
use VM\ApiBundle\Entity\CompanyReport;
use VM\ApiBundle\Entity\GroupRoundReportCode;
use VM\ApiBundle\Entity\OfferReport;
use VM\ApiBundle\Entity\RDFExport;
use VM\ApiBundle\Entity\Round;
use VM\ApiBundle\Entity\User;
use VM\ApiBundle\Entity\UserGroups;
use VM\FinancialStatementsBundle\Services\AccountChanges\AccountChanges;
use VM\FinancialStatementsBundle\Services\FinancialStatementGame;
use VM\FinancialStatementsBundle\Services\Reports\FullReport;
use VM\FinancialStatementsBundle\Services\Reports\SimpleReport;
use VM\PackageGeneratorBundle\Services\Export\ExportProcessCreator;

class ResetGroupService
{
    /**
     * @var ApiGetter
     */
    protected $ApiGetter;

    /**
     * @var \Doctrine\ORM\EntityManager
     */
    protected $EntityManager;

    /**
     * @var Company
     */
    protected $Company;

    /**
     * @var UserGroups
     */
    protected $Group;

    /**
     * @var String
     */
    protected $rootDir;


    public function __construct(ApiGetter $ApiGetter, $rootDir)
    {
        $this->rootDir = $rootDir;
        $this->ApiGetter = $ApiGetter;
        $this->EntityManager = $this->ApiGetter->getEntityManager();
    }

    public function resetGroup(UserGroups $Group, $endOfGame)
    {
        $CurrentRound = $this->ApiGetter->getGroupActualRound($Group);

        if(empty($Group) || empty($CurrentRound))
        {
            throw new \Exception("Group is null.");
        }

        $this->Group = $Group;
        $Company = $this->ApiGetter->getGroupCompanyOrFalse($Group);
        $this->EntityManager->beginTransaction();

        if($Company instanceof Company)
        {
            $this->Company = $Company;


            $this->removeCompanyAllegroCategoryItems();
            $this->removeCompanyBankServiceOptionsAndAccountChanges();
            $this->removeCompanyDistributionSales();
            $this->removeCompanyEmployees();
            $this->removeCompanyRoundOffers();
            $this->removeCompanyOfferReports();
            $this->removeCompanyPKDRelation();
            $this->removeCompanyRoundReports();
            $this->removeCompanyRDFExports();
            $this->removeSummaryCompanyRounds();
            $this->removeSummaryRoundBankServiceOption();

            $this->removeCompany();
        }

        $this->resetGroupRounds();
        $this->setResetFlag($endOfGame);

        $this->EntityManager->flush();
        $this->EntityManager->commit();
    }

    protected function setResetFlag($endOfGame)
    {
        $this->Group->setWasReset(!$endOfGame);
        $this->EntityManager->flush();
    }

    protected function removeSummaryRoundBankServiceOption()
    {
        $SummaryRoundBankServiceOptions = $this->Company->getSummaryRoundBankServiceOption();
        foreach($SummaryRoundBankServiceOptions as $SummaryRoundBankServiceOption)
        {
            $this->EntityManager->remove($SummaryRoundBankServiceOption);
        }
        $this->EntityManager->flush();
    }

    protected function removeSummaryCompanyRounds()
    {
        $SummaryCompanyRounds = $this->Company->getSummaryCompanyRound();
        foreach($SummaryCompanyRounds as $SummaryCompanyRound)
        {
            $this->EntityManager->remove($SummaryCompanyRound);
        }
        $this->EntityManager->flush();
    }

    protected function resetGroupRounds()
    {
        $Rounds = $this->Group->getRounds();
        /** @var Round $Round */
        foreach($Rounds as $Round)
        {
            $Round->setStartAt(null);
            $Round->setEndAt(null);
            $Round->setIsCounting(false);
            $Round->setIsDone(false);
            $Round->setMarket(0);
        }
        $this->EntityManager->flush();
    }

    protected function removeCompanyRDFExports()
    {
        $RDFExports = $this->EntityManager->getRepository('VMApiBundle:RDFExport')
            ->findBy(array('company' => $this->Company));

        /** RDFExport $RDFExport */
        foreach($RDFExports as $RDFExport)
        {
            $this->EntityManager->remove($RDFExport);
        }
        $this->EntityManager->flush();
    }

    protected function removeCompany()
    {
        $this->EntityManager->remove($this->Company);
        $this->EntityManager->flush();
    }

    protected function removeCompanyRoundReports()
    {
        $CompanyRoundReports = $this->Company->getRoundReports();
        /** @var CompanyReport $CompanyRoundReport */
        foreach($CompanyRoundReports as $CompanyRoundReport)
        {
            // rootDir ====== ./app
            $pathLevels = explode('/', $CompanyRoundReport->getDataUrl());
            $dataUrl = $this->rootDir.'/../web/'.$pathLevels[1].'/'.$pathLevels[2];

            // really, REALLY BE CAREFUL because bad path can delete all your project files
            system("rm -rf ".escapeshellarg($dataUrl));

            $this->EntityManager->remove($CompanyRoundReport);
        }
    }

    protected function removeCompanyPKDRelation()
    {
        $CompanyPKDs = $this->Company->getCodesPkd();
        /** @var PKD $CompanyPKD */
        foreach($CompanyPKDs as $CompanyPKD)
        {
            $this->Company->removeCodesPkd($CompanyPKD);
        }
        $this->EntityManager->flush();
    }

    protected function removeCompanyBankServiceOptionsAndAccountChanges()
    {
        $CompanyBankServiceOptions = $this->Company->getBankServiceOptions();

        /** @var CompanyBankServiceOption $CompanyBankServiceOption */
        foreach($CompanyBankServiceOptions as $CompanyBankServiceOption)
        {
            $AccountChanges = $CompanyBankServiceOption->getAccountChanges();
            /** @var AccountChange $AccountChanges */
            foreach($AccountChanges as $AccountChange)
            {
                $this->EntityManager->remove($AccountChange);
            }
            $this->EntityManager->remove($CompanyBankServiceOption);
        }
        $this->EntityManager->flush();
    }

    protected function removeCompanyAllegroCategoryItems()
    {
        $CompanyAllegroCategoryItems = $this->Company->getPlaces();
        /** @var CompanyAllegroCategoryItem $CompanyAllegroCategoryItem */
        foreach($CompanyAllegroCategoryItems as $CompanyAllegroCategoryItem)
        {
            $this->EntityManager->remove($CompanyAllegroCategoryItem);
        }
        $this->EntityManager->flush();
    }

    protected function removeCompanyDistributionSales()
    {
        $CompanyDistributionSales = $this->Company->getCompanyDistributionSales();
        /** @var CompanyDistributionSales $CompanyDistributionSale */
        foreach($CompanyDistributionSales as $CompanyDistributionSale)
        {
            $this->EntityManager->remove($CompanyDistributionSale);
        }
        $this->EntityManager->flush();
    }

    protected function removeCompanyEmployees()
    {
        $CompanyEmployees = $this->Company->getCompanyEmployees();
        /** @var CompanyEmployee $CompanyEmployee */
        foreach($CompanyEmployees as $CompanyEmployee)
        {
            $this->EntityManager->remove($CompanyEmployee);
        }
        $this->EntityManager->flush();
    }

    protected function removeCompanyRoundOffers()
    {
        $CompanyOffers = $this->Company->getRoundOffers();
        /** @var CompanyOffer $CompanyOffer */
        foreach($CompanyOffers as $CompanyOffer)
        {
            $this->EntityManager->remove($CompanyOffer);
        }
        $this->EntityManager->flush();
    }

    protected function removeCompanyOfferReports()
    {
        $CompanyOfferReports = $this->Company->getCompanyOfferReports();
        /** @var CompanyOfferReport $CompanyOfferReport */
        foreach($CompanyOfferReports as $CompanyOfferReport)
        {
            $this->Company->removeCompanyOfferReport($CompanyOfferReport);
            $this->EntityManager->remove($CompanyOfferReport);
        }
        $this->EntityManager->flush();
    }
}